#pragma compile(Icon, "AutoIt_Main_v10_48x48_only_RGB-A.ico")
#include <GDIPlus.au3>
#include <GuiConstantsEx.au3>
#include <WindowsConstants.au3>

AutoItSetOption("GUIOnEventMode", 1)
_GDIPlus_Startup()

Global Const $iW = 800, $iH = 600, $sTitle = "Sphere v2 / FPS: "
Global Const $hGUI = GUICreate($sTitle & 0, $iW, $iH)
GUISetState()
Global Const $hDC = _WinAPI_GetDC($hGUI)
Global Const $hHBitmap = _WinAPI_CreateCompatibleBitmap($hDC, $iW, $iH)
Global Const $hDC_backbuffer = _WinAPI_CreateCompatibleDC($hDC)
Global Const $DC_obj = _WinAPI_SelectObject($hDC_backbuffer, $hHBitmap)
Global Const $hCanvas = _GDIPlus_GraphicsCreateFromHDC($hDC_backbuffer)
_GDIPlus_GraphicsSetPixelOffsetMode($hCanvas, 4)
_GDIPlus_GraphicsSetSmoothingMode($hCanvas, 4)
_GDIPlus_GraphicsClear($hCanvas)
Global Const $hBrush = _GDIPlus_BrushCreateSolid(0xFFFFFFFF), $hpath = _GDIPlus_PathCreate()

Global Const $fPI = ACos(-1), $fRad = $fPI / 180, $iWh = $iW / 2, $iHh = $iH / 2
Global $i, $iFPS = 0, $iDots = 250, $fSphereRadius = 150, $fRatio = 1 + $fSphereRadius * 0.005, $aDots[$iDots][3], $fTheta, $fRho, $fPhi, $fX, $fY, $fZ, _
	   $fXAngle = 0, $fYAngle = 0, $fZAngle = 0, $iColor, $c
ConsoleWrite($fRatio & @CRLF)
_GDIPlus_PathAddEllipse($hPath, 1 + $iWh - $fSphereRadius, 1 + $iHh - $fSphereRadius, 2 * $fSphereRadius, 2 * $fSphereRadius)
Global Const $hBrush_Gradient = _GDIPlus_PathBrushCreateFromPath($hPath)
_GDIPlus_PathBrushSetCenterColor($hBrush_Gradient, 0xF8FFFFFF)
_GDIPlus_PathBrushSetCenterPoint($hBrush_Gradient, $iWh, $iHh)
_GDIPlus_PathBrushSetSurroundColor($hBrush_Gradient, 0x40101010)
_GDIPlus_PathBrushSetGammaCorrection($hBrush_Gradient, True)

;create sphere (https://de.wikipedia.org/wiki/Kugelkoordinaten)
For $i = 0 To $iDots - 1
	$fTheta = $i  / $iDots * 41
	$fPhi = ($i / $iDots) * $fPi
	$aDots[$i][0] = $fSphereRadius * Sin($fPhi) * Cos($fTheta)
	$aDots[$i][1] = $fSphereRadius * Cos($fPhi)
	$aDots[$i][2] = $fSphereRadius * Sin($fPhi) * Sin($fTheta)
Next

GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit")
AdlibRegister("CalcFPS", 1000)

Do
	_GDIPlus_GraphicsClear($hCanvas, 0xFF000000)
	_GDIPlus_GraphicsFillEllipse($hCanvas, 1 + $iWh - $fSphereRadius, 1 + $iHh - $fSphereRadius, 2 * $fSphereRadius, 2 * $fSphereRadius, $hBrush_Gradient)
	For $i = 0 To $iDots - 1
		_3Dto2D($aDots[$i][0], $aDots[$i][1], $aDots[$i][2], $fXAngle, $fYAngle, $fZAngle, $fX, $fY, $fZ)
		$c = Int($fZ * $fRatio)
		$iColor = $c > 0xFF ? 0xFF : $c
		_GDIPlus_BrushSetSolidColor($hBrush, 0xE0000000 + $iColor * 0x10000 + $iColor * 0x100 + $iColor)
		If $fZ > -0.01 Then _GDIPlus_GraphicsFillEllipse($hCanvas, $iWh + $fX, $iHh + $fY, $fZ / 8, $fZ / 8, $hBrush)
	Next
	$fXAngle += 1.25
	$fZAngle -= 0.75
	_WinAPI_BitBlt($hDC, 0, 0, $iW, $iH, $hDC_backbuffer, 0, 0, $SRCCOPY)
	$iFPS += 1
Until Not Sleep(10)

Func _Exit()
	_GDIPlus_PathDispose($hPath)
	_GDIPlus_BrushDispose($hBrush)
	_GDIPlus_BrushDispose($hBrush_Gradient)
	_GDIPlus_GraphicsDispose($hCanvas)
	_WinAPI_SelectObject($hDC, $DC_obj)
	_WinAPI_DeleteObject($hHBitmap)
	_WinAPI_ReleaseDC($hGUI, $hDC)
	_GDIPlus_Shutdown()
	GUIDelete()
	Exit
EndFunc

Func CalcFPS()
	WinSetTitle($hGUI, "", $sTitle & $iFPS)
	$iFPS = 0
EndFunc

Func _3Dto2D($fX, $fY, $fZ, $fRotX, $fRotY, $fRotZ, ByRef $fXPos, ByRef $fYPos, ByRef $fZPos)
	;apply the x-axis rotation to transform coordinates ($fX, $fY, $fZ) into coordinates ($fX0, $fY0, $fZ0)
	Local $f1 = $fRotX * $fRad, $f2 = Cos($f1), $f3 = Sin($f1)
	Local Const $fY0 = $fY * $f2 + $fZ * $f3
	Local Const $fZ0 = $fZ * $f2 - $fY * $f3

	;apply the y-axis rotation to ($fX0, $fY0, $fZ0) to obtain ($fX1, $fY1, $fZ1)
	$f1 = $fRotY * $fRad
	$f2 = Cos($f1)
	$f3 = Sin($f1)
	Local Const $fX1 = $fX * $f2 - $fZ0 * $f3
	Local Const $fY1 = $fY0
	Local Const $fZ1 = $fZ0 * $f2 + $fX * $f2

	;finally, apply the z-axis rotation to obtain the point ($fXPos, $fYPos)
	$f1 = $fRotZ * $fRad
	$f2 = Cos($f1)
	$f3 = Sin($f1)
	$fXPos = $fX1 * $f2 + $fY1 * $f3
	$fYPos = $fY1 * $f2 - $fX1 * $f3
	$fZPos = $fZ0
EndFunc